#ifndef _MISSIONLOOP_H__
#define _MISSIONLOOP_H__

#include <list>
#include <vector>
#include "sprig.h"
#include "Player.h"
#include "Level.h"
#include "Libraries/PL_Loop.h"

using namespace PL;
using namespace std;

void showMission(GameState* gs, Level& level);

class MissionState : public PL_State
{
	public:
	
	const char* text;
	float startDelay;
	SDL_Surface* screen;
	
	MissionState()
		: PL_State()
		, text(NULL)
		, startDelay(1.000)
		, screen(NULL)
	{
	    
    }
	
	virtual ~MissionState()
	{}
	
};

class MissionUpdate : public PL_Update
{
	public:
	
	MissionUpdate()
		: PL_Update()
	{}
	
	virtual ~MissionUpdate()
	{}
	
    virtual void update(PL_State* state);
};

class MissionDraw : public PL_Draw
{
	public:
	
	MissionDraw()
		: PL_Draw()
	{}
	
	virtual ~MissionDraw()
	{}
	
    virtual void draw(PL_State* state);
	
};

class MissionEvent : public PL_AnyEvent
{
	public:
	MissionEvent()
		: PL_AnyEvent()
	{}
	
	virtual ~MissionEvent()
	{}
	
    virtual bool handleEvent(PL_State* state, SDL_Event& event);
	
};











#endif


